/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;

public class CertSignReq
implements CertMgtConstants {
    public static final int RETURN_OK = 0;
    public static final int RETURN_INVALID_NUM_OF_ARGS = 16;
    public static final int RETURN_EXCEPTION = 32;
    public static final int RETURN_INSUFFICIENT = 48;
    public static final int RETURN_EXTRANEOUS = 64;
    public static final int RETURN_UNKNOWN = 80;
    private static int INDEX_OF_LAST_FIXED_ARG = 10;
    private static final String TRACE_MASKD = "XCRTCSRD";
    private static final String TRACE_MASKF = "XCRTCSRF";
    private static final String TRACE_MASKT = "XCRTCSRT";
    private static final String VIEW_PARM = "view";
    private static final String CREATE_PARM = "create";
    private static final String SIGN_TILL_PARM = "signTill";
    private static final String SIGN_FOR_PARM = "signFor";
    private static final String SHOW_DATE_PARM = "showDate";
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyMMddHHmmssZ");
    private String country = null;
    private String state = null;
    private String locality = null;
    private String org = null;
    private String orgUnit = null;
    private String hostName = null;
    private String eMailAddr = null;
    private HashSet alternateDNSNames = null;
    private HashSet ipAddresses = null;

    CertSignReq(String country, String state, String locality, String org, String orgUnit, String hostName, String eMailAddr, HashSet alternateDNSNames, HashSet ipAddresses) {
        this.country = country;
        this.state = state;
        this.locality = locality;
        this.org = org;
        this.orgUnit = orgUnit;
        this.hostName = hostName;
        this.eMailAddr = eMailAddr;
        this.alternateDNSNames = alternateDNSNames;
        this.ipAddresses = ipAddresses;
        Trace.trace(TRACE_MASKT, "<->CertSignReq(" + country + ", " + state + ", " + locality + ", " + org + ", " + orgUnit + ", " + hostName + ", " + eMailAddr + ")");
    }

    public static void main(String[] args) {
        int i;
        HashSet<String> alternateDNSNames = null;
        HashSet<String> ipAddresses = null;
        boolean removePassPhrase = false;
        String passPhrase = null;
        Date startDate = null;
        Date endDate = null;
        Date now = null;
        GregorianCalendar endDateCalendar = null;
        Date tillDate = null;
        String eMailAddr = null;
        StringBuffer argsLine = new StringBuffer();
        for (int i2 = 0; i2 < args.length; ++i2) {
            argsLine.append(' ');
            argsLine.append(args[i2]);
        }
        Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + argsLine.toString());
        if (args.length < 1) {
            CertSignReq.displayHelp();
            CertUtils.doExit(16);
        }
        for (i = 0; i < args.length; ++i) {
            args[i] = args[i].replaceAll("0x20", " ");
        }
        try {
            if (args[0].equalsIgnoreCase(VIEW_PARM)) {
                if (args.length != 2) {
                    CertSignReq.displayHelp();
                    CertUtils.doExit(16);
                }
                CertSignReq.view(args[0]);
            } else if (args[0].equalsIgnoreCase(CREATE_PARM)) {
                if (args.length < INDEX_OF_LAST_FIXED_ARG + 1) {
                    CertSignReq.displayHelp();
                    CertUtils.doExit(16);
                }
                alternateDNSNames = new HashSet<String>();
                ipAddresses = new HashSet<String>();
                for (i = INDEX_OF_LAST_FIXED_ARG + 1; i < args.length; ++i) {
                    if (CertUtils.isIPAddress(args[i])) {
                        ipAddresses.add(args[i]);
                        continue;
                    }
                    alternateDNSNames.add(args[i]);
                }
                if (!args[9].equalsIgnoreCase("NULL")) {
                    eMailAddr = args[9];
                }
                if (args[10].equalsIgnoreCase("true")) {
                    removePassPhrase = true;
                }
                passPhrase = new CertSignReq(args[3], args[4], args[5], args[6], args[7], args[8], eMailAddr, alternateDNSNames, ipAddresses).writeToFile(args[1], args[2], removePassPhrase);
                if (!removePassPhrase) {
                    System.err.println("The passphrase of the server key file " + args[2] + " is " + passPhrase + ".");
                }
            } else if (args[0].equalsIgnoreCase(SIGN_TILL_PARM)) {
                if (args.length != 9) {
                    CertSignReq.displayHelp();
                    CertUtils.doExit(16);
                }
                try {
                    startDate = DATE_FORMATTER.parse(args[6]);
                    endDate = DATE_FORMATTER.parse(args[7]);
                    CertSignReq.signByCA(args[1], args[2], args[3], args[4], args[5], startDate, endDate, args[8]);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    CertUtils.doExit(32);
                }
            } else if (args[0].equalsIgnoreCase(SIGN_FOR_PARM)) {
                if (args.length != 9) {
                    CertSignReq.displayHelp();
                    CertUtils.doExit(16);
                }
                now = new Date();
                endDateCalendar = new GregorianCalendar();
                endDateCalendar.setTime(now);
                endDateCalendar.add(5, Integer.parseInt(args[7]));
                tillDate = endDateCalendar.getTime();
                try {
                    startDate = DATE_FORMATTER.parse(args[6]);
                    CertSignReq.signByCA(args[1], args[2], args[3], args[4], args[5], startDate, tillDate, args[8]);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    CertUtils.doExit(32);
                }
            } else if (args[0].equalsIgnoreCase(SHOW_DATE_PARM)) {
                if (args.length != 2) {
                    CertSignReq.displayHelp();
                    CertUtils.doExit(16);
                }
                now = new Date();
                endDateCalendar = new GregorianCalendar();
                endDateCalendar.setTime(now);
                endDateCalendar.add(5, Integer.parseInt(args[1]));
                tillDate = endDateCalendar.getTime();
                System.out.println(args[1] + " days from now is " + endDateCalendar.getTime());
            } else {
                CertSignReq.displayHelp();
                CertUtils.doExit(81);
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKD, e);
            e.printStackTrace();
            CertUtils.doExit(32);
        }
        CertUtils.doExit(0);
    }

    private static void displayHelp() {
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq create' csrFile serverKeyFile country state");
        System.out.println("          locality org orgUnit hostName eMailAddr removePassPhrase");
        System.out.println("          [altDNSName | altIPAddress]...");
        System.out.println("");
        System.out.println("csrFile is the fully qualified name of the certificate signing request file to create.");
        System.out.println("serverKeyFile is the fully qualified name of the server key file to create.");
        System.out.println("country the two letter country code (e.g. US).");
        System.out.println("state the state or province (e.g. CA).");
        System.out.println("locality the locality (e.g. Los Angeles).");
        System.out.println("org the organization (e.g. IBM).");
        System.out.println("orgUnit the organization unit (e.g. HMC).");
        System.out.println("hostName the fully qualified host name of the server for which the certificate is requested.");
        System.out.println("eMailAddr the email address to put in the certificate signing request; 'NULL' if none should be added.");
        System.out.println("removePassPhrase remove the passphrase from the resulting server key file to create if");
        System.out.println(" this argument is specified as 'true'; do not remove the passphrase and write it to");
        System.out.println(" to stdout otherwise.");
        System.out.println("altDNSName is a DNS name, other than the fully qualified host name, by which the host");
        System.out.println("  is known. The name(s) will be added to the certificate in the subjectAltName field.");
        System.out.println("altIPAddress is an IP address by which the host is known. The address(es) will be");
        System.out.println("  added to the certificate in the subjectAltName field.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq view' certificateSigningRequestFileToView");
        System.out.println("");
        System.out.println("certificateSigningRequestFileToView is the fully qualified name of the certificate signing request file to view.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq signTill' certificateSigningRequestFileToSign");
        System.out.println("          signingKeyFile signingCertFile databaseFile serialFile startDate endDate resultingCertificateFile");
        System.out.println("");
        System.out.println("certificateSigningRequestFileToSign is the fully qualified name of");
        System.out.println(" the certificate signing request file to sign.");
        System.out.println("signingKeyFile is the fully qualified name of the key file used to sign");
        System.out.println(" the certificate signing request.");
        System.out.println("signingCertFile is the fully qualified name of the CA certificate file.");
        System.out.println("databaseFile is the fully qualified name of the CA database file.");
        System.out.println("serialFile is the fully qualified name of the CA serial file.");
        System.out.println("startDate the date that the certificate is valid from. It is specified in the ASN1");
        System.out.println(" UTCTime format (YYMMDDHHMMSSZ).");
        System.out.println("endDate the date that the certificate is valid till. It is specified in the ASN1");
        System.out.println(" UTCTime format (YYMMDDHHMMSSZ).");
        System.out.println("resultingCertificateFile is the fully qualified name of where the resulting");
        System.out.println(" certificate file will be written.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq signFor' certificateSigningRequestFileToSign");
        System.out.println("          signingKeyFile signingCertFile databaseFile serialFile startDate numOfDays resultingCertificateFile");
        System.out.println("");
        System.out.println("certificateSigningRequestFileToSign is the fully qualified name of");
        System.out.println(" the certificate signing request file to sign.");
        System.out.println("signingKeyFile is the fully qualified name of the key file used to sign");
        System.out.println(" the certificate signing request.");
        System.out.println("signingCertFile is the fully qualified name of the CA certificate file.");
        System.out.println("databaseFile is the fully qualified name of the CA database file.");
        System.out.println("serialFile is the fully qualified name of the CA serial file.");
        System.out.println("startDate the date that the certificate is valid from. It is specified in the ASN1");
        System.out.println(" UTCTime format (YYMMDDHHMMSSZ).");
        System.out.println("numOfDays the number of days that the certificate is valid for.");
        System.out.println("resultingCertificateFile is the fully qualified name of where the resulting");
        System.out.println(" certificate file will be written.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq showDate' numOfDays");
        System.out.println("");
        System.out.println("numOfDays the number of days from now for the date to be shown");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println("Any substring, found within an argument, to be equal to \"0x20\" (without the quotes),");
        System.out.println("will be replaced with a space character. This is to allow blanks to be embedded in");
        System.out.println("the arguments if needed. Yes, I know this is a hack but time is money.");
        System.out.println("");
        System.out.println("The above command syntax above uses the following conventions:");
        System.out.println("");
        System.out.println("Literal tokens in the specified command are denoted by being enclosed in single quotes.");
        System.out.println("When specified, the single quotes should not be specified.");
        System.out.println("");
        System.out.println("Tokens that are not literal tokens should be replaced with the appropriate value.");
        System.out.println("");
        System.out.println("Tokens that are optional are enclosed in square brackets. If more than one token is");
        System.out.println("included and separated by a vertical bar, you can chose one or none of the tokens.");
        System.out.println("Neither the square brackets or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If there are multiple token choices but one is required, the tokens are enclosed in");
        System.out.println("braces and separated by a vertical bar.");
        System.out.println("Neither the braces or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If a token or group of tokens, grouped by square brackets or braces, can be repeated,");
        System.out.println("a sequence of three periods will follow the token or token group.");
    }

    String writeToFile(String fileName, String serverKeyFile, boolean removePassPhrase) throws HException {
        String e22;
        block16: {
            File randomFile;
            String tempPassPhrase;
            block14: {
                String e22;
                block15: {
                    tempPassPhrase = null;
                    String csrCommand = null;
                    String removePassCommand = null;
                    randomFile = null;
                    String randomFileName = null;
                    String[] env = null;
                    String subjectAltNames = null;
                    File tempDirFile = null;
                    String openSSLPath = null;
                    String configFileWithAltsAndEMail = null;
                    String configFileWithoutAltsButEMail = null;
                    String configFileWithAltsButNoEMail = null;
                    String configFileWithoutAltsOrEMail = null;
                    String tempDir = null;
                    try {
                        openSSLPath = BaseFileControl.getFilePath("openssl");
                        configFileWithAltsAndEMail = CertUtils.getFQFileName("CSR.cnf");
                        configFileWithoutAltsButEMail = CertUtils.getFQFileName("CSRNoAlts.cnf");
                        configFileWithAltsButNoEMail = CertUtils.getFQFileName("CSRNoEMail.cnf");
                        configFileWithoutAltsOrEMail = CertUtils.getFQFileName("CSRNoAltsOrEMail.cnf");
                        tempDir = BaseFileControl.getFilePath("tmp");
                    }
                    catch (HException e22) {
                        new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e22).log();
                        throw e22;
                    }
                    tempPassPhrase = CertUtils.getRandomString();
                    csrCommand = openSSLPath + "openssl req -new -out " + fileName + " -passout pass:" + tempPassPhrase + " -keyout " + serverKeyFile;
                    if (tempDir == null) {
                        throw new HException("Temporary directory can not be determined.");
                    }
                    tempDirFile = new File(tempDir);
                    randomFile = File.createTempFile(TRACE_MASKT, null, tempDirFile);
                    randomFileName = randomFile.getCanonicalPath();
                    subjectAltNames = this.getSubjectAltNamesAsString();
                    if (subjectAltNames.length() > 0) {
                        if (this.eMailAddr != null) {
                            env = new String[9];
                            env[7] = "EMAIL_ADDRESS=" + this.eMailAddr;
                            env[8] = "SUBJECT_ALT_NAME=" + subjectAltNames;
                            csrCommand = csrCommand + " -config " + configFileWithAltsAndEMail;
                        } else {
                            env = new String[8];
                            env[7] = "SUBJECT_ALT_NAME=" + subjectAltNames;
                            csrCommand = csrCommand + " -config " + configFileWithAltsButNoEMail;
                        }
                    } else if (this.eMailAddr != null) {
                        env = new String[8];
                        env[7] = "EMAIL_ADDRESS=" + this.eMailAddr;
                        csrCommand = csrCommand + " -config " + configFileWithoutAltsButEMail;
                    } else {
                        env = new String[7];
                        csrCommand = csrCommand + " -config " + configFileWithoutAltsOrEMail;
                    }
                    env[0] = "RANDOM_FILE=" + randomFile;
                    env[1] = "COUNTRY=" + this.country;
                    env[2] = "STATE=" + this.state;
                    env[3] = "LOCALITY=" + this.locality;
                    env[4] = "ORGANIZATION=" + this.org;
                    env[5] = "ORGANIZATION_UNIT=" + this.orgUnit;
                    env[6] = "COMMON_NAME=" + this.hostName;
                    CertUtils.executeCommand(csrCommand, env, removePassPhrase);
                    if (!removePassPhrase) break block14;
                    removePassCommand = openSSLPath + "openssl rsa -in " + serverKeyFile + " -out " + serverKeyFile + " -passin pass:" + tempPassPhrase;
                    CertUtils.executeCommand(removePassCommand);
                    e22 = null;
                    Object var20_22 = null;
                    if (randomFile == null) break block15;
                    randomFile.delete();
                    randomFile = null;
                }
                return e22;
            }
            try {
                e22 = tempPassPhrase;
                Object var20_23 = null;
                if (randomFile == null) break block16;
                randomFile.delete();
            }
            catch (IOException e3) {
                try {
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 12, e3).log();
                    throw new HException(e3);
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var20_24 = null;
                        if (randomFile == null) break block17;
                        randomFile.delete();
                        randomFile = null;
                    }
                    throw throwable;
                }
            }
            randomFile = null;
        }
        return e22;
    }

    void sign(String cSRFileName, String keyFile, String cACertFile, String databaseFile, String serialFile, int daysToUseOnCreate, boolean isSelfSigned, boolean isForCA, String passPhrase, String certFile) throws HException {
        String createCertCommand = null;
        String openSSLPath = null;
        String selfSignedConfigFile = null;
        String selfSignedCAConfigFile = null;
        String[] env = null;
        Date now = null;
        GregorianCalendar endDateCalendar = null;
        Date tillDate = null;
        String subjectAltNames = null;
        try {
            selfSignedConfigFile = CertUtils.getFQFileName("selfSignedCert.cnf");
            selfSignedCAConfigFile = CertUtils.getFQFileName("CACert.cnf");
            openSSLPath = BaseFileControl.getFilePath("openssl");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        now = new Date();
        endDateCalendar = new GregorianCalendar();
        endDateCalendar.setTime(now);
        endDateCalendar.add(5, daysToUseOnCreate);
        tillDate = endDateCalendar.getTime();
        if (isSelfSigned) {
            subjectAltNames = this.getSubjectAltNamesAsString();
            if (subjectAltNames != null && subjectAltNames.length() > 0) {
                env = new String[]{"SUBJECT_ALT_NAME=" + subjectAltNames};
            }
            createCertCommand = openSSLPath + "openssl x509 -in " + cSRFileName + " -out " + certFile + " -req -signkey " + keyFile + " -days " + daysToUseOnCreate;
            if (passPhrase != null) {
                createCertCommand = createCertCommand + " -passin pass:" + passPhrase;
            }
            createCertCommand = isForCA ? createCertCommand + " -extfile " + selfSignedCAConfigFile + " -extensions v3_self_signed_CA" : createCertCommand + " -extfile " + selfSignedConfigFile + " -extensions v3_self_signed";
            CertUtils.executeCommand(createCertCommand, env, passPhrase == null);
        } else {
            CertSignReq.signByCA(cSRFileName, keyFile, cACertFile, databaseFile, serialFile, now, tillDate, certFile);
        }
    }

    private static void signByCA(String cSRFileName, String keyFile, String cACertFile, String databaseFile, String serialFile, Date startDate, Date endDate, String certFile) throws HException {
        String createCertCommand = null;
        String openSSLPath = null;
        String cASignedConfigFile = null;
        String[] env = null;
        String certFileDir = null;
        Trace.trace(TRACE_MASKT, "->signByCA(" + cSRFileName + ", " + keyFile + ", " + cACertFile + ", " + databaseFile + ", " + serialFile + ", " + startDate + ", " + endDate + ", " + certFile + ")");
        try {
            cASignedConfigFile = CertUtils.getFQFileName("CASignedCert.cnf");
            openSSLPath = BaseFileControl.getFilePath("openssl");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        certFileDir = new File(certFile).getParent();
        env = new String[]{"NEW_CERTS_DIR=" + (certFileDir != null ? certFileDir : File.separator), "DATABASE=" + databaseFile, "SERIAL=" + serialFile};
        createCertCommand = openSSLPath + "openssl ca" + " -in " + cSRFileName + " -out " + certFile + " -config " + cASignedConfigFile + " -keyfile " + keyFile + " -batch" + " -startdate " + DATE_FORMATTER.format(startDate) + " -enddate " + DATE_FORMATTER.format(endDate);
        createCertCommand = createCertCommand + " -extensions v3_CA_signed" + " -cert " + cACertFile;
        CertUtils.executeCommand(createCertCommand, env);
        Trace.trace(TRACE_MASKT, "<-signByCA()");
    }

    private static void view(String fileName) throws HException {
        String viewCommand = null;
        String openSSLPath = null;
        try {
            openSSLPath = BaseFileControl.getFilePath("openssl");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        viewCommand = openSSLPath + "openssl req -in " + fileName + " -text";
        CertUtils.executeCommand(viewCommand);
    }

    private String getSubjectAltNamesAsString() {
        Iterator i;
        StringBuffer subjectAltNameBuf = null;
        boolean addedEntry = false;
        subjectAltNameBuf = new StringBuffer();
        if (this.alternateDNSNames != null) {
            i = this.alternateDNSNames.iterator();
            while (i.hasNext()) {
                if (addedEntry) {
                    subjectAltNameBuf.append(',');
                }
                subjectAltNameBuf.append("DNS:");
                subjectAltNameBuf.append((String)i.next());
                addedEntry = true;
            }
        }
        if (this.ipAddresses != null) {
            i = this.ipAddresses.iterator();
            while (i.hasNext()) {
                if (addedEntry) {
                    subjectAltNameBuf.append(',');
                }
                subjectAltNameBuf.append("IP:");
                subjectAltNameBuf.append((String)i.next());
                addedEntry = true;
            }
        }
        return subjectAltNameBuf.toString();
    }
}

